<?php
class creativedesign extends CREATIVEDESIGNSms {

    function __construct($message,$gsmnumber,$countryCode=""){
        $this->message = $this->utilmessage($message);
        $this->gsmnumber = $this->utilgsmnumber($gsmnumber);
        $this->countryCode = $countryCode;
    }

    private function file_get_contents_curl($url) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    public function send()
    {
        $log = [];
        $error = [];
        $msgid = null;

        if ($this->gsmnumber == "numbererror") {
            $log[] = "Number format error: " . $this->gsmnumber;
            $error[] = "Number format error: " . $this->gsmnumber;
            return [
                'log' => $log,
                'error' => $error,
                'msgid' => $msgid,
            ];
        }

        $params = $this->getParams();

        $number = str_replace(['+', '-', ' '], '', $this->gsmnumber);
        $apiKey = trim($params->apiKey);
        // $senderid লাইনটি বাদ দেওয়া হয়েছে
        $message = urlencode($this->message);

        // ✅ BulkSMSBD API endpoint (Sender ID removed)
        $url = "https://www.creativedesign.com.bd/api/smsapi?"
             . "api_key={$apiKey}"
             . "&type=text"
             . "&number={$number}"
             // senderid প্যারামিটারটি এখান থেকে বাদ দেওয়া হয়েছে
             . "&message={$message}";

        $log[] = "Sending request to: $url";

        $result = $this->file_get_contents_curl($url);
        $log[] = "Response: $result";

        // ✅ check API response
        if (stripos($result, 'SMS Send Successfully') !== false || stripos($result, 'success') !== false) {
            return [
                'log' => $log,
                'error' => null,
                'msgid' => uniqid('sms_')
            ];
        } else {
            $error[] = "API Error: " . $result;
            return [
                'log' => $log,
                'error' => $error,
                'msgid' => null
            ];
        }
    }

    public function balance()
    {
        return null;
    }

    public function report($msgid)
    {
        return null;
    }

    public function utilgsmnumber($number)
    {
        return str_replace(['+', '-', ' '], '', $number);
    }

    public function utilmessage($message)
    {
        return $message;
    }
}

return array(
    'value' => 'creativedesignsms',
    'label' => 'BulkSMSBD.net',
    'fields' => array(
        'apiKey', 'signature' // এখান থেকেও senderid বাদ দেওয়া হয়েছে
    )
);